import json
import re
import os
import glob

def evaluate_manual(json_path):
    with open(json_path, 'r', encoding='utf-8') as f:
        data_list = json.load(f)  
    
    TP = FP = FN = TN = 0  
    total = 0
    correct = 0
    yes_count = 0

    for item in data_list:
        gt = item.get('label', '').lower() 
        pred = None

        ans = item.get("model_answer", '')
         # Only keep the first sentence
        if ans.find('.') != -1:
            ans = ans.split('.')[0]

        ans = ans.replace(',', '')
        words = ans.split(' ')
        if 'No' in words or 'not' in words or 'no' in words:
            pred= 'no'
        else:
            pred = 'yes'

        if pred == gt:
            correct += 1
        total += 1
        
        if pred == 'yes':
            yes_count += 1

        if gt == 'yes' and pred == 'yes':
            TP += 1
        elif gt == 'no' and pred == 'yes':
            FP += 1
        elif gt == 'yes' and pred == 'no':
            FN += 1
        elif gt == 'no' and pred == 'no':
            TN += 1

    accuracy = correct / total if total > 0 else 0

    precision = TP / (TP + FP) if (TP + FP) > 0 else 0
    recall    = TP / (TP + FN) if (TP + FN) > 0 else 0

    if precision + recall == 0:
        f1 = 0
    else:
        f1 = 2 * precision * recall / (precision + recall)
    
    yes_ratio = yes_count/total

    '''    
    print(f"Accuracy: {accuracy:.4f}")
    print(f"Precison: {precision:.4f}")
    print(f"Recall: {recall:.4f}")
    print(f"F1 score (positive = 'yes'): {f1:.4f}")
    print(f"yes_ratio: {yes_ratio:.4f}")
    '''
    return { 
        "file": os.path.basename(file_path),
        "Accuracy": accuracy,
        "Precison":precision,
        "Recall":recall,
        "F1 score":f1,
        "yes_ratio":yes_ratio,
        }



    #print(f"TP={TP}, FP={FP}, FN={FN}, TN={TN}")

if __name__ == '__main__':
    
    input_folder = "tci/results/pope"
    output_file = "tci/eval/res_pope_alpha+=4.json"

    json_files = glob.glob(os.path.join(input_folder, "*.json"))

    all_results = []

    for file_path in json_files:
        try:
            result = evaluate_manual(file_path)
            all_results.append(result)
            print(f"Processed {file_path}")
        except Exception as e:
            print(f"Error processing {file_path}: {e}")

    with open(output_file, "w") as f:
        json.dump(all_results, f, indent=4)
    print(f"All results saved to {output_file}")
    

